/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import io.github.lukebemish.dynamic_asset_generator.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.platform.Services;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ModConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    public static final Path CONFIG_PATH = Services.PLATFORM.getConfigFolder();
    public static final String FULL_PATH = CONFIG_PATH.toString() + "/dynamic_asset_generator.json";
    public static final Path ASSET_CACHE_FOLDER = CONFIG_PATH.resolve("dynamic_asset_generator/asset_cache");
    public static final Path DATA_CACHE_FOLDER = CONFIG_PATH.resolve("dynamic_asset_generator/data_cache");
    public static final int CURRENT_VERSION = 1;
    @Expose
    public int format = 1;
    @Expose
    public boolean cacheAssets = false;
    @Expose
    public boolean cacheData = false;

    private static ModConfig load() {
        ModConfig config = new ModConfig();
        try {
            ModConfig.checkExistence();
            config = (ModConfig)GSON.fromJson((Reader)new FileReader(FULL_PATH), ModConfig.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static ModConfig get() {
        ModConfig config = ModConfig.load();
        if (config.format != 1) {
            DynamicAssetGenerator.LOGGER.error("Config is outdated! An attempt to load with this config would crash. Using default config instead...");
            return new ModConfig();
        }
        return config;
    }

    public static void save(ModConfig config) {
        try {
            ModConfig.checkExistence();
            FileWriter writer = new FileWriter(FULL_PATH);
            GSON.toJson((Object)config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void checkExistence() throws IOException {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        }
        if (!Files.exists(Paths.get(FULL_PATH, new String[0]), new LinkOption[0])) {
            Files.createFile(Paths.get(FULL_PATH, new String[0]), new FileAttribute[0]);
            ModConfig.save(new ModConfig());
        }
    }
}

